<?php
/**
 * Admin authentication handler
 */

// Set session parameters for better persistence
ini_set('session.gc_maxlifetime', 3600); // 1 hour
session_set_cookie_params(3600); // 1 hour
session_start();
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST');
header('Access-Control-Allow-Headers: Content-Type');

$PASSWORD_FILE = 'admin_password.txt';
$DEFAULT_PASSWORD = 'admin123';

try {
    $input = json_decode(file_get_contents('php://input'), true);
    $action = $input['action'] ?? '';
    
    if ($action === 'login') {
        $password = $input['password'] ?? '';
        
        // Get stored password or use default
        $storedPassword = $DEFAULT_PASSWORD;
        if (file_exists($PASSWORD_FILE)) {
            $storedPassword = trim(file_get_contents($PASSWORD_FILE));
        }
        
        if ($password === $storedPassword) {
            $_SESSION['admin_authenticated'] = true;
            echo json_encode(['success' => true, 'message' => 'Login successful']);
        } else {
            echo json_encode(['success' => false, 'message' => 'Invalid password']);
        }
    } 
    elseif ($action === 'change_password') {
        if (!isset($_SESSION['admin_authenticated']) || !$_SESSION['admin_authenticated']) {
            throw new Exception('Not authenticated');
        }
        
        $currentPassword = $input['current_password'] ?? '';
        $newPassword = $input['new_password'] ?? '';
        
        if (empty($newPassword) || strlen($newPassword) < 6) {
            throw new Exception('New password must be at least 6 characters');
        }
        
        // Verify current password
        $storedPassword = $DEFAULT_PASSWORD;
        if (file_exists($PASSWORD_FILE)) {
            $storedPassword = trim(file_get_contents($PASSWORD_FILE));
        }
        
        if ($currentPassword !== $storedPassword) {
            throw new Exception('Current password is incorrect');
        }
        
        // Save new password
        if (file_put_contents($PASSWORD_FILE, $newPassword) === false) {
            throw new Exception('Failed to save new password');
        }
        
        echo json_encode(['success' => true, 'message' => 'Password changed successfully']);
    }
    elseif ($action === 'check_auth') {
        $authenticated = isset($_SESSION['admin_authenticated']) && $_SESSION['admin_authenticated'];
        echo json_encode(['authenticated' => $authenticated]);
    }
    elseif ($action === 'logout') {
        $_SESSION['admin_authenticated'] = false;
        session_destroy();
        echo json_encode(['success' => true, 'message' => 'Logged out']);
    }
    else {
        throw new Exception('Invalid action');
    }
    
} catch (Exception $e) {
    http_response_code(400);
    echo json_encode(['success' => false, 'message' => $e->getMessage()]);
}
?>